﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using PpmsDataService.ModelsEnumTypes;
using System.ComponentModel.DataAnnotations.Schema;
using System.Windows.Controls;
using Microsoft.Xrm.Sdk.Metadata;

namespace PpmsDataService.Models
{
    public class Provider
    {

        public string ProviderIdentifier { get; set; }

        public ProviderIdentifierType ProviderIdentifierType { get; set; }

        public string Name { get; set; }

        public ProviderType ProviderType { get; set; }

        public int QualityRankingTotalScore { get; set; }

        public string QualityRankingLastUpdated { get; set; }

        public string MainPhone { get; set; }

        public string Email { get; set; }

        public string PrimaryDirectMessagingAddress { get; set; }

        public string SecondaryDirectMessagingAddress { get; set; }

        public EMRSystem? EMRSystem { get; set; }

        public string EMRSystemOther { get; set; }

        public string Address { get; set; }

        public string AddressStreet { get; set; }

        public string AddressCity { get; set; }

        public string AddressStateProvince { get; set; }

        public string AddressPostalCode { get; set; }

        public string AddressCounty { get; set; }

        public string AddressCountry { get; set; }

        public ProviderStatusReason ProviderStatusReason { get; set; }

        //Provider Affiliations
        public bool PrimaryCarePhysician { get; set; }

        //Individual

       // public DateTime DateOfBirth {get; set;}

        public bool IsAcceptingNewPatients { get; set; }

        public ProviderEthnicity ProviderEthnicity { get; set; }

        public ProviderGender ProviderGender { get; set; }

        public string Religion { get; set; }

        //Organization
        public string OrganizationId { get; set; }

        public ServiceProviderType ServiceProviderType { get; set; }

        public string SpecialInstruction { get; set; }

        public string OwnedCareSiteName { get; set; }

        public virtual IQueryable<CareSite> OwnedCareSite { get; set; }

        public string OrganizationFax { get; set; }

        public OrganizationStatus OrganizationStatus { get; set; }

        //Internal / External Details
        public bool IsExternal { get; set; }

        public InternalType InternalType { get; set; }

        public string LicensingJuristicion { get; set; }

        public bool CanCreateHealthCareOrders { get; set; }

        public InternalAppointmentStatus InternalAppointmentStatus { get; set; }

        public ExternalHealthProviderType ExternalHealthProviderType { get; set; }

        public bool OnLeie { get; set; }
        public string ExternalInstitutionDeaNumber { get; set; }

        public string ExternalLeieCheckDate { get; set; }


        public string ValidationSource { get; set; }

        //Contact Preferences
        public bool ContactMethodEmail { get; set; }

        public bool ContactMethodFax { get; set; }

        public bool ContactMethodVirtuPro { get; set; }

        public bool ContactMethodHSRM { get; set; }

        public bool ContactMethodPhone { get; set; }

        public bool ContactMethodMail { get; set; }

        public bool ContactMethodRefDoc { get; set; }


        public bool BulkEmails { get; set; }

        public bool BulkMails { get; set; }

        public bool Emails { get; set; }

        public bool Mails { get; set; }

        public bool PhoneCalls { get; set; }

        public bool Faxes { get; set; }

        public virtual IQueryable<ProviderCredential> ProviderCredentials { get; set; }

        public virtual IQueryable<ProviderSpecialty> ProviderSpecialties { get; set; }

        public virtual IQueryable<ProviderPrivilege> ProviderPrivileges { get; set; }

        public virtual IQueryable<ProviderIdentifier> ProviderIdentifiers { get; set; }

        public virtual IQueryable<ProviderLicense> ProviderLicenses { get; set; }

        public virtual IQueryable<ProviderService> ProviderServices { get; set; }

        public virtual IQueryable<CareSite> CareSites { get; set; }

        public virtual IQueryable<DEA> DEAs { get; set; }

        public virtual IQueryable<Provider> OwningOrganization { get; set; }

        public virtual IQueryable<Provider> Providers { get; set; }

        public virtual IQueryable<ProviderContact> ProviderContacts { get; set; }

        public virtual IQueryable<VaProviderRelationship> VaProviderRelationships { get; set; }

        public virtual IQueryable<ProviderNetwork> ProviderNetworks { get; set; }

        [Key]
        public int Id { get; set; }

        public DateTime ModifiedOnDate { get; set; }

        public DateTime TerminationDate { get; set; }

    }
}